/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.logging;

import java.util.Hashtable;

public class Level {
    private String name;
    private int value;
    private static Hashtable registry = new Hashtable();
    public static final Level TRACE = new Level("TRACE", 0);
    public static final Level DEBUG = new Level("DEBUG", 1);
    public static final Level INFO = new Level("INFO", 100);
    public static final Level WARN = new Level("WARN", 300);
    public static final Level ERROR = new Level("ERROR", 500);
    public static final Level DEFAULT = INFO;

    public Level(String name, int value) {
        this.name = name == null ? "" : name;
        this.value = value;
        registry.put(name, this);
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static Level findByName(String name) {
        return (Level)registry.get(name);
    }

    public boolean equals(Object obj) {
        return ((Level)obj).value == this.value;
    }

    public String toString() {
        return "Name: " + this.name + ", Level: " + this.value;
    }
}

